/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware.massStorage;

import jace.hardware.massStorage.DiskNode;
import jace.hardware.massStorage.ProdosVirtualDisk;
import jace.hardware.massStorage.SubNode;
import java.io.IOException;

public class FreespaceBitmap
extends DiskNode {
    int size = 16;

    public FreespaceBitmap(ProdosVirtualDisk fs, int start) throws IOException {
        this.setBaseBlock(start);
        this.setOwnerFilesystem(fs);
        for (int i = 1; i < this.size; ++i) {
            new SubNode(i, this, start + i);
        }
    }

    @Override
    public void doDeallocate() {
    }

    @Override
    public void doAllocate() {
    }

    @Override
    public void doRefresh() {
    }

    @Override
    public void readBlock(int sequence, byte[] buffer) throws IOException {
        int startBlock = sequence * 512 * 8;
        int endBlock = (sequence + 1) * 512 * 8;
        int bitCounter = 0;
        int pos = 0;
        int value = 0;
        for (int i = startBlock; i < endBlock; ++i) {
            if (!this.getOwnerFilesystem().isAllocated(i)) {
                ++value;
            }
            if (++bitCounter < 8) {
                value *= 2;
                continue;
            }
            bitCounter = 0;
            buffer[pos++] = (byte)value;
            value = 0;
        }
    }
}

